function niemaxprojfast(folder)
%%
folder='geneseq01';

maxprojfolder=[folder,'maxproj'];
mkdir(maxprojfolder)
S=load(['Posinfo_regoffset',folder,'.mat']);
labellist=S.labellist;
%% parse filenames

rootdir=cd(folder);
fnames=dir('*.tif');
fnames={fnames.name};
C=cellfun(@(x) textscan(x,'xy%uz%uc%u.tif'),fnames,'UniformOutput',false);

xy=cellfun(@(x) cell2mat(x(1)),C);
z=cellfun(@(x) cell2mat(x(2)),C);
ch=cellfun(@(x) cell2mat(x(3)),C);


uniq_xy=unique(xy);
uniq_ch=unique(ch);
%%
for i=1:numel(uniq_xy)
	for n=1:numel(uniq_ch)
		fov_fnames=fnames(xy==uniq_xy(i)&ch==uniq_ch(n));
		first_img=imread(fov_fnames{1});
		img=repmat(first_img,1,1,numel(fov_fnames));
		for m=2:numel(fov_fnames)
			img(:,:,m)=imread(fov_fnames{m});
		end
		max_img=max(img,[],3);
		if n==1
			imwrite(max_img,fullfile(rootdir,maxprojfolder,[labellist{uniq_xy(i)},'.tif']));
			
		else
			imwrite(max_img,fullfile(rootdir,maxprojfolder,[labellist{uniq_xy(i)},'.tif']), ...
				'WriteMode','append');
			
		end

	end
end	
cd(rootdir)
%%
end